#/log
####**/log** - the directory where platform logs are stored, there are 3 standard log files in **RESTup5**:

| Log File          | controller variable name | class variable name |
|:----------------- | :----------------------- | :------------------ |
| **application.log** | $appLog | $this->appLog  |
| **error.log**       | $errorLog | $this->errorLog |
| **debug.log**       | $debugLog | $this->debugLog |


Should you require additional logs, they are declared as follows:

>
```
    $myLog = new Logger();
    $myLog->file = 'my.log';
    $myLog->init();
```

To write to this new log there are two methods:

**1.** The legacy RESTup versions 1 - 4 way.
>
```
    $myLog->desc="Entry Description";
    $myLog->date=$dataToLog;
    $myLog->writeLog();
```


**2.** The RESTup5 way, (RESTup5 can use either method).
>
```
    $myLog->writeLog("Entry Description",$dataToLog);
```

Method **1** is the legacy method from all earlier RESTup versions, whilst **2** was introduced in RESTup5.

Log files are always stored in the directory defined by the **$logDir** variable.

You don't need to add timestamps to log entries as each entry in a log is automatically timestamped eg:

>Excerpt from a debug.log:
```
20161017-142222.156     XML:    <?xml version="1.0" encoding="utf-8" standalone="yes"?>
<databases>
```

><dl><dt>Excerpt from an application.log:</dt>
<dd>
<pre>
20161016-184734.513     Request 127.0.0.1       GET     http://restup5.local/check
Request Parameters: <br />
20161016-184734.513     Response: json  {"databases":{"information_schema":{"tables":{"CHARACTER_SETS":null,"COLLATIONS":null...
</pre>
</dd>
</dl>

##Support
Should you require help with configuring your web-server, send an email detailing your web-server server to [customer.support@covirtual.net](mailto:customer.support@covirtual.net).

<dl>
<dt>Useful Links</dt>
<dd>
<a href="/README"><em>Documentation Home</em></a><br />
<a href="/"><em>RESTup5 Server</em></a><br />
<a href="http://www.covirtual.net"><em>CoVirtual.Net</em></a>
</dd>
</dl>
