#/database
##DDL for databases
RDBMs (SQL databases including: MySQL, PostgreSQL, Oracle, DB/2, SQL Server, Sybase) all use DDL files to create databases, tables, views, stored procedures, stored functions, events and triggers, the /database directory is where these files are stored on a RESTup5 server.

##Sample database
The DDL for the sample database **sample.sql** is contained in the [**/database**](/database) directory.

><dl>
<dt>Listing of /database/sample.sql</dt>
<dd>
<pre>
--
-- sample - a sample database for the RESTup5 RESTful Web Services Platform.
--<br/>
create database if not exists sample;<br />
use sample;<br />
--
-- This table is for use with mysql 5.6 and above, if using earlier versions, change the default value for created from
-- CURRENT_TIMESTAMP to '2000-01-01 10:00:00' or some other valid date in the past.
--<br />
create table users (
    userID             bigint  unsigned    not null    auto_increment  primary key,
    userParentID       bigint  unsigned    not null    default 1,
    userName           varchar(30)         not null    default '',
    userPassword       char(41)            not null    default '*E0EA3FA83967803674C4DC584B0F9666F93D00F7',  -- password('Passw0rd1')
    firstName          varchar(30)         not null    default '',
    lastName           varchar(40)         not null    default '',
    primaryEmail       varchar(128)        not null    default '',
    userRoles          integer unsigned    not null    default 0,
    userStatus         integer unsigned    not null    default 1,
    created            datetime            not null    default CURRENT_TIMESTAMP,
    createdBy          bigint  unsigned    not null    default 1,
    updated            datetime            not null    default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
    updatedBy          bigint  unsigned    not null    default 1,
    unique key ix_userDetails (userName, userPassword, firstName, lastName, primaryEmail)
) Engine InnoDB character set 'utf8' comment 'users table';<br />
-- create the admin user.
insert into users values (1,1,'admin',password('sysadmin'),'System','Administrator','sysadmin@localhost','1023',1,now(),1,now(),1);<br />
-- change the auto_increment value to 10001 to be ready for the first web user.
alter table users auto_increment=10001;<br />
create table groups (
    groupID            bigint  unsigned    not null    auto_increment  primary key,
    groupName          varchar(30)         not null    default '',
    groupDescription   text                not null,
    groupRoleLevel     integer unsigned    not null    default 1,
    groupStatus        integer unsigned    not null    default 1,
    created            datetime            not null    default CURRENT_TIMESTAMP,
    createdBy          bigint  unsigned    not null    default 1,
    updated            datetime            not null    default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
    updatedBy          bigint  unsigned    not null    default 1,
    unique key ix_group_name (groupName)
) Engine InnoDB character set 'utf8' comment 'groups table' auto_increment 10001;<br />
create table groups_users (
    groupID            bigint  unsigned    not null    default 10001,
    userID             bigint  unsigned    not null    default 10001,
    groupUserStatus    integer unsigned    not null    default 1,
    created            datetime            not null    default CURRENT_TIMESTAMP,
    createdBy          bigint  unsigned    not null    default 1,
    updated            datetime            not null    default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
    updatedBy          bigint  unsigned    not null    default 1,
    primary key ix_groupuser (groupID, userID),
    foreign key fk_groups_users_ibfk_001 (groupID) references groups (groupID),
    foreign key fk_groups_users_ibfk_002 (userID) references users (userID)
) Engine InnoDB character set 'utf8' comment 'groups_users table';<br/>
create or replace definer='root'@'localhost' view vw_user_groups as
select
    u.userID
    ,u.firstName
    ,u.lastName
    ,group_concat(g.groupName separator ', ') usersGroups
    ,sum(g.groupRoleLevel) as groupRoleLevel
    ,(sum(g.groupRoleLevel) | u.userRoles) roleLevel
    ,concat ('[', group_concat(g.groupID separator ','), ']') groupIDs
from groups_users gu 
    join groups g on g.groupID=gu.groupID 
    join users u on u.userID=gu.userID 
group by gu.userID;<br/>
-- base groups
insert into groups (groupName, groupDescription, groupRoleLevel) values 
('employees','All Staff and Contractors',1),
('staff','Staff on PAYG or Sallary',2),
('accounts','Accounts Entry Operators',4);<br />
-- sample entry
insert into groups_users (groupID, userID, groupUserStatus) values (10001,1,1), (10002,1,1), (10003,1,1);
</pre>
</dd>
</dl>

##Support##
Should you require help with configuring your web-server, send an email detailing your web-server server to [customer.support@covirtual.net](mailto:customer.support@covirtual.net).

<dl>
<dt>Useful Links</dt>
<dd>
<a href="/README"><em>Documentation Home</em></a><br />
<a href="/tutorials"><em>Tutorials</em></a><br />
<a href="/"><em>RESTup5 Server</em></a><br />
<a href="http://www.covirtual.net"><em>CoVirtual.Net</em></a>
</dd>
</dl>
