#Controller Workflow
The Controller for the RESTup5 platform is index.php in the Webroot (www) directory.

The purpose of this page is to describe the workflow of this page and how different core variables interact and change the flow of information through the controller.

## Each new request is processed through the controller as follows:

* Load the base functions and standard platform libraries from bin/base.php.
* Initialise the three logfiles if the don't exist / configure log files if the do exist.
* Initialise the current instance of the server / controller.
* populate the $chkConf server configuration array.
* populate the $curMethodOrView and $reqMethodOrView parameters.
* set default values for core controller variables.
* read the request headers to obtain additional request headers.
* run the clientConfChecks function to override the previous defaults from server or method  configs and request override values.
* obtain and process the details of client making the request.
* handle the Request Method type and throw a 405 Error for invalid Request Methods.
* Log the request to log/application.log ($appLog).
* Test whether this is a root view or an application view, adjust paths and variables accordingly.
* Test whether view requires authentication or not, if it does:
    * check if the client is using API key authentication.
        * if using API key authentication verify the key and grant access
        * if NOT using the API key get and decrypt the platform cookie.
            * if the cookie does not exist or is empty or corrupted, redirect to a login screen.
            * if the cookie is not corrupt, decrypt it and verify the user details contained therein.


