#/conf - the configuration directory
This is where all platform **configuration** files are placed in a **RESTup5** server.
The **RESTup5** Web Services Framework uses [JSON](http://www.json.org) for all configuration files because this format offers the best options for both system and web applications as it is easily consumed by javascript, PHP, PERL, JAVA, .NET, C++, Python and several other languages.

##serverConf.json
The following is the default serverConf.json distributed in the standard RESTup5 package and consists of 3 sections:
* git - the software repository version release information.
* server - the configuration parameters for this specific server instance.
* siteOwner - The Legal entity name of the site owner eg: Acme PLC.

```
{
  "git":"$Id: $",
  "server":
  {
    "hostsAllowed":"*",
    "hostsDenied":[],
    "clientKeys":["-sJInthPQQVqPzwILWjlp38YFAxmcUTePHHy2O5MBurcI_na6bZZ_Un.PC2D0MPq"],
    "requestProtocols":["https","http"],
    "requestMethods":["GET","POST","PUT","DELETE","HEAD","OPTIONS"],
    "debugLevel":0
  },
  "siteOwner":"REPLACE WITH YOUR DETAILS"
}
```

###server section
####hostsAllowed
>Value may be <em>"*"</em> (distribution package default) or an Array of string containing one ipaddress or cidr per string eg:
```
    "hostsAllowed":["172.16.0.10","10.10.0/16","202.33.166.133"],
```

>It is also possible to to allow all using </em>"*"</em> and black-list specific hosts in the <em>hostsDenied</em> entry below.

####hostsDenied
>Value may be an empty Array meaning no hosts are denied access (distribution package default) or an array of string containing ipaddress or cidr per string eg:
```
    "hostsDenied":["172.16.0.20","10.0./16","202.33.166.136"],
```

####clientKeys
>When you configure your RESTup5 Server you should alter the **clientKeys** entry to a string of 65 (or more characters) including numbers 0-9, Upper and Lower case letters [a-z] [A-Z] minus '-', Underscore '_'.  Each individual client machine should have its own clientKey specified as an entry in the clientKeys array as fillows:

>```
    "clientKeys":["first host's key","second host's key,......,"nth host's key"],
```

>**Note:** You can generate a client key by using the following url: <a href="/genClientKey">/genClientKey</a> (to generate additional keys, reload your browser), copy only the actual quoted key into your <em>serverConf.json</em> file. For example genClientKey resulted in:
```
    {"clientKey":"3dec9a67-fc4e-3ed9-428c5eb6c38c-e7201a57630e-dfe9-9f83-48ade"}
```
>Copy the <em>"3dec9a67-fc4e-3ed9-428c5eb6c38c-e7201a57630e-dfe9-9f83-48ade"</em> part into the clientKeys array:

>```
    "clientKeys":["3dec9a67-fc4e-3ed9-428c5eb6c38c-e7201a57630e-dfe9-9f83-48ade"],
```

>**Note:** Client applications on remote hosts using **client key Authentication**, *MUST* place their key in a request header as demonstrated in the following code snippets:

><dl>
<dt>PHP Sample</dt>
<dd>
<pre>
&lt;?php
    // somewhere in your client application
    header("hostKey: 3dec9a67-fc4e-3ed9-428c5eb6c38c-e7201a57630e-dfe9-9f83-48ade");
    ...
?&gt;
</pre>
</dd>
</dl>

><dl>
<dt>A jQuery sample:</dt>
<dd>
<pre>
$.ajax({
&nbsp;&nbsp;&nbsp;&nbsp;url: 'your RESTup5 url',
&nbsp;&nbsp;&nbsp;&nbsp;headers: {
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'hostKey':'3dec9a67-fc4e-3ed9-428c5eb6c38c-e7201a57630e-dfe9-9f83-48ade',
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'Content-Type':'application/json'
&nbsp;&nbsp;&nbsp;&nbsp;},
&nbsp;&nbsp;&nbsp;&nbsp;method: 'POST',
&nbsp;&nbsp;&nbsp;&nbsp;dataType: 'json',
&nbsp;&nbsp;&nbsp;&nbsp;data: Your-JSON-Data,
&nbsp;&nbsp;&nbsp;&nbsp;success: function(data){
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;console.log('success: ' + data);
&nbsp;&nbsp;&nbsp;&nbsp;}
});
</pre>
</dd>
</dl>
    
####requestProtocols
Array of string names of protocols accepted by the server which be one or both of **https** or **http** (distribution package default) eg:
>**https** and **http** (default)
```
    "requestProtocols":["https","http"],
```

>**https** only
```
    "requestProtocols":["https"],
```

>**http** only
```
    "requestProtocols":["http"],
```

>**Note:** If you wish to run the https protocol, you must obtain an ssl certificate and configure your web-server to use it.

####requestMethods
By default a RESTup5 Web Services server accepts the **GET**, **POST**, **PUT**, **DELETE** and **HEAD** request methods of **[http 1.1](https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html)**

####debugLevel
An integer bitmap value which correlates to the verbosity of debug information written into the debug log which may be used and over-ridden as required by developers see below:
>
| debugLevel | meaning |
| ---------: | :---------------- |
| 0 | no debug data (the default value) |
| 1 | configuration variables |
| 2 | validator results |
| 4 | database debug info including SQL executed, timings and results. |
| 8 | ldap / Active Directory debug info including queries executed, timings and results. |
|16 | no-SQL debugging. |
|32 | used for ad-hoc debuging. |


###siteOwner

The value of this key should be the legal name of the entity operating this server eg: *Your Company Name*


##Database configuration files
Database configuration files contain the host, authentication credentials and database along with some meta fields and debugging information, and are always prefixed with "DB_", see a sample database config file below:
>**DB_sample.json** sample database configuration file.
>
```
{
    "git":"$Id: $"
    "comment":"connector for sample database",
    "Host":"localhost",
    "User":"dbUsername",
    "Pass":"dbSecret",
    "DB":"dbName",
    "debugLevel":0,
    "strDebugOutput":"sample database",
}
```
>**Description of each variable.**
>
| variable | purpose / description |
| :-------------- | :------------------------------------- |
| git | Version of this file from the version control system |
| comment | Description of which database this configuration works with |
| Host | The hostname or ipaddress of the machine or proxy on which the database resides |
| User | The username for the connection |
| Pass | The password for the connection |
| DB | the database name for the connection (may be empty if using multiple databases on the same Host) |
| debugLevel | Integer - defines what to place in the debugLog, levels 0, 1, 2, 4 and 32 are applicable from above |
| strDebugOutput | string - containing the prefix to be prepended to debugLog entries to indicate which database connector made the entry |

##Method configuration files
Method configuration files auto configure methods and must be named to match the method they configure eg:

>**<pre>/lib/methodName.php is configured by /conf/methodName.json</pre>** Other configuration filenames *WILL NOT* work.

>
<dl><dt>sample of a method configuration file</dt>
<dd>
<pre>
{
&nbsp;&nbsp;&nbsp;&nbsp;"requiresAuthentication":true,
&nbsp;&nbsp;&nbsp;&nbsp;"requestProtocols":["https","http"],
&nbsp;&nbsp;&nbsp;&nbsp;"respType":"json"
}
</pre>
</dd>
</dl>

>**variables** explained
>
| variable | purpose / description |
| :-------------- | :------------------------------------- |
| requiresAuthentication | client application must use either a clientKey or the user must be logged-in to access this method |  
| requestProtocols | refer to requestProtocols in serverConf.json, specific only to this method (see note 1 below) |
| respType | the response application type: one of json, text, html, xml or pdf |
| methodToggle | if null, empty, missing or not defined then normal operation<br>if 1 or true then "Method or View unavailable" is displayed (HTML views) or send back for REST requests |
| .... | you may place any additional method specific variables in here as well eg: |
| australianStates | {"Choose a state: ":["ACT","NSW","NT","QLD","SA","TAS","VIC","WA"]} | 

>
<dl><dt>Sample with our method specific example</dt>
<dd>
<pre>
{
&nbsp;&nbsp;&nbsp;&nbsp;"requiresAuthentication":true,
&nbsp;&nbsp;&nbsp;&nbsp;"requestProtocols":["https","http"],
&nbsp;&nbsp;&nbsp;&nbsp;"respType":"json",
&nbsp;&nbsp;&nbsp;&nbsp;"australianStates":{"Choose a state: ":["ACT","NSW","NT","QLD","SA","TAS","VIC","WA"]}
}
</pre>
</dd>
</dl>

##Support
Should you require help with configuring your web-server, send an email detailing your web-server server to [customer.support@covirtual.net](mailto:customer.support@covirtual.net).

<dl>
<dt>Useful Links</dt>
<dd>
<a href="/README"><em>Documentation Home</em></a><br />
<a href="/"><em>RESTup5 Server</em></a><br />
<a href="http://www.covirtual.net"><em>CoVirtual.Net</em></a>
</dd>
</dl>
