#Introduction
##Overview
![RESTup5 Architecture Overview](/images/RESTup5_Architecture.png)

**RESTup5** is the fifth major version of the RESTup Web Services platform for PHP which has been developed by George Embrey, project Founder and CIO of CoVirtual.Net Pty. Ltd., in Sydney and Melbourne Australia since November 2009.

Some of the key features of RESTup5 include:

* Full MVC Architecture for web applications.
    * Models may be any relational database, name value pair store, JSON document store, Active Directory / Open Directory, CSV, TSV, JSON or XML data sourrce.
    * Views may be one of html documents (.htm|.html), include files (html snippets with a .inc extension), .php documents with (or without) their associated .tpl template file(s).  
    * Controllers, the master controller is index.php which resides in the webroot (www) folder in the framework.
* TWIG template engine (earlier versions employed Smarty v3 template engine).
* Bootstrap CSS framework.
* jQuery and AngularJS frameworks.
* Application documentation may be written using <a href="http://daringfireball.net/projects/markdown/syntax" target="_blank">**Markdown**</a> and stored in the [**/doc**](/doc) directory with a **.md** file extension. 

##Core
The [**core**](/core) Variables and Functions of the RESTup5 framework can be found [**here**](/core).

##Directory Structure
>[**/bin**](/bin) - Core Libraries and Classes

>[**/conf**](/conf) - JSON configuration files for the platform and per connector, view or method.

>[**/connectors**](/connectors) - Database, MongoDB, Active Directory | LDAP, Hadoop, Cassandra connector Classes.

>[**/database**](/database) - DDL files for Databases are stored here. 

>[**/doc**](/doc) - Documentation files for the platform and User Generated In-Code Documentation.

>[**/lib**](/lib) - REST Method Classes.

>[**/log**](/log) - Log files, typically application.log, debug.log, error.log

>[**/scripts**](/scripts) - System maintenance and management scripts are placed here.

>[**/tmp**](/tmp) - Temporary files created and cleaned up during processing.

>[**/templates**](/templates) - PHP, TWIG and HTML templates.

>[**/views**](/views) - PHP, HTML, HTML, PHTM and INC views.

>[**/www**](/www) - webroot and location of controllers. Additional Directories can be added in this branch of the directory tree for additional processing etc...

>>[**/css**](/www-css) - CSS files

>>[**/documents**](/www-documents) - .PDF, .DOC(X), .XLS(X), .PPT(X), other binary documents accessible from the web.

>>[**/js**](/www-js) - Javascript files.

>>[**/images**](/www-images) - Image files for web applications.

>>[**/templates_c**](/www-templates_c) - compiled templates.

>>[**/uploads**](/www-uploads) - Uploaded files.

<dl>
<dt>Useful Links</dt>
<dd>
<a href="/tutorials"><em>Tutorials</em></a><br />
<a href="/"><em>RESTup5 Server</em></a><br />
<a href="http://www.covirtual.net"><em>CoVirtual.Net</em></a>
</dd>
</dl>
